/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;

class VWPrivilegedActionHelper
implements PrivilegedAction {
    public static final int TYPE_JAVA_PROPERTY = 0;
    public static final int TYPE_CLASS_LOADER = 1;
    public static final int TYPE_SYSTEM_CLASS_LOADER = 2;
    public static final int TYPE_THREAD_CLASS_LOADER = 3;
    private int m_nType = -1;
    private String m_propertyName = null;
    private Class m_class = null;
    private URL m_url = null;

    protected VWPrivilegedActionHelper(int nType, String propertyName) {
        this.m_nType = nType;
        this.m_propertyName = propertyName;
    }

    protected VWPrivilegedActionHelper(int nType, Class cls, URL url) {
        this.m_nType = nType;
        this.m_class = cls;
        this.m_url = url;
    }

    protected static final String getPrivilegedJavaProperty(String propertyName) {
        Object obj = AccessController.doPrivileged(new VWPrivilegedActionHelper(0, propertyName));
        return (String)obj;
    }

    protected static final ClassLoader getPrivilegedClassLoader(Class cls, URL url) {
        Object obj = AccessController.doPrivileged(new VWPrivilegedActionHelper(1, cls, url));
        return (ClassLoader)obj;
    }

    protected static final ClassLoader getPrivilegedSystemClassLoader(URL url) {
        Object obj = AccessController.doPrivileged(new VWPrivilegedActionHelper(2, null, url));
        return (ClassLoader)obj;
    }

    protected static final ClassLoader getPrivilegedThreadClassLoader(URL url) {
        Object obj = AccessController.doPrivileged(new VWPrivilegedActionHelper(3, null, url));
        return (ClassLoader)obj;
    }

    protected static String _get_FILE_DATE() {
        return "$Date:   12 Sep 2006 14:25:20  $";
    }

    protected static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    protected static String _get_FILE_REVISION() {
        return "$Revision:   1.1  $";
    }

    public Object run() {
        switch (this.m_nType) {
            case 0: {
                return System.getProperty(this.m_propertyName);
            }
            case 1: {
                return this.getExtendedClassLoader(this.m_class.getClassLoader(), this.m_url);
            }
            case 2: {
                return this.getExtendedClassLoader(ClassLoader.getSystemClassLoader(), this.m_url);
            }
            case 3: {
                return this.getExtendedClassLoader(Thread.currentThread().getContextClassLoader(), this.m_url);
            }
        }
        return null;
    }

    private ClassLoader getExtendedClassLoader(ClassLoader classLoader, URL url) {
        if (url != null && classLoader != null) {
            URL[] urls = new URL[]{url};
            return new URLClassLoader(urls, classLoader);
        }
        return classLoader;
    }
}

